# outside Options
#
#--------------------------------------------------------------------------------
# get Data from Stata
rm(list=ls())
source("/home/oliver/.Rprofile")
library("foreign")
setwd("/home/oliver/Forschung/OutsideOption/data")
ooData = read.dta("ootmp.dta")
attach(ooData)
ooData.A1 = ooData[second==0 & sessiontype=="A no outside option",]
ooData.B1 = ooData[second==0 & sessiontype=="B opp. has equal oo",]
ooData.C1 = ooData[second==0 & sessiontype=="C opp. has random oo",]
ooData.A2 = ooData[second==1 & sessiontype=="A no outside option",]
ooData.C2 = ooData[second==1 & sessiontype=="C opp. has random oo",]
ooData.A1$opt = 25 + ooData.A1$v/2
ooData.A2$opt = ooData.A2$v
ooData.B1$opt = 25 + ooData.B1$v/2 - ooData.B1$oo
ooData.C1$x = ooData.C1$v - ooData.C1$oo
x = ooData.C1$x
ooData.C1$opt = ifelse(x<50,2/3 * x,(100*x*x-2*x*x*x/3-250000/3)/(200*x-x*x-5000))
ooData.C2$opt = ooData.C2$v - ooData.C2$oo
save(ooData.A1,ooData.A2,ooData.B1,ooData.C1,ooData.C2,file="ooData.Rdta")
#--------------------------------------------------------------------------------
source("/home/oliver/.Rprofile")
load("ooData.Rdta")

y=unique(ooData.C2$oo)
length(y)
x=unique(ooData.C1$oo)
length(x)

boxplot(ooData.A1$bid ~ ooData.A1$opt )
psline(cbind(levels(factor(ooData.A1$v)),aggregate(ooData.A1$bid,list(ooData.A1$opt),median)$x))

myquant = function(treat) {
  treat$over=treat$bid-treat$opt
  for (qq in c(25,50,75)) {
    cat("\\pstextpath[r]{\\psline")
    cat(apply ( psspline(treat[,c("opt","over")],q=qq)[,c(2,3)], 1, function(x) {sprintf("(%g,%g)",x[1],x[2])}),sep="") ;
    cat(sprintf("}{%g}\n",qq))
  }
}

myquant(ooData.A1)
myquant(ooData.A2)
myquant(ooData.B1)
myquant(ooData.C1)
myquant(ooData.C2)


plot(ooData.A2$v,ooData.A2$opt)
plot(ooData.A2$opt,ooData.A2$bid)
psline(cbind(levels(factor(ooData.A2$v)),aggregate(ooData.A2$bid,list(ooData.A2$opt),median)$x))

plot(ooData.B1$v,ooData.B1$opt)
plot(ooData.B1$opt,ooData.B1$bid)
#
plot(ooData.C1$v,ooData.C1$opt)
plot(ooData.C1$opt,ooData.C1$bid)

plot(ooData.C2$v,ooData.C2$opt)
plot(ooData.C2$opt,ooData.C2$bid)
psline(cbind(levels(factor(ooData.C2$opt)),aggregate(ooData.C2$bid,list(ooData.C2$opt),median)$x))

plot(psspline(ooData.A1[,c("opt","bid")])[,c("opt","bid")],type="l")
abline(0,1,col="red")
plot(psspline(ooData.A2[,c("opt","bid")])[,c("opt","bid")],type="l")
abline(0,1,col="red")
plot(psspline(ooData.C1[,c("opt","bid")])[,c("opt","bid")],type="l")
abline(0,1,col="red")
plot(psspline(ooData.C2[,c("opt","bid")])[,c("opt","bid")],type="l")
abline(0,1,col="red")

#
#--------------------------------------------------------------------------------
#
c.A1 = t(sapply(by(ooData.A1,list(sid = ooData.A1$sid),function(x) lm (bid ~ v,data = x)),coef))
plot(c.A1)
cumul(c.A1[,"v"])
cumul(c.A1[,"(Intercept)"])
#
c.A2 = t(sapply(by(ooData.A2,list(sid = ooData.A2$sid),function(x) lm (bid ~ v,data = x)),coef))
plot(c.A2)
cumul(c.A2[,"v"])
cumul(c.A2[,"(Intercept)"])
#
c.B1 = t(sapply(by(ooData.B1,list(sid = ooData.B1$sid),function(x) lm (bid ~ v + oo,data = x)),coef))
plot(c.B1[,c("v","oo")])
cumul(c.B1[,"v"])
cumul(c.B1[,"oo"])
cumul(c.B1[,"(Intercept)"])
#
ooData.C1$Del=ifelse(ooData.C1$x<50,0,ooData.C1$opt-2/3*ooData.C1$x)
c.C1 = t(sapply(by(ooData.C1,list(sid = ooData.C1$sid),function(x) lm (bid ~ v + oo + Del,data = x)),coef))
plot(c.C1[,c("v","oo")])
plot(c.C1[,c("v","Del")])
plot(c.C1[,c("oo","Del")])
cumul(c.C1[,"v"])
cumul(c.C1[,"oo"])
cumul(c.C1[,"Del"])
cumul(c.C1[,"(Intercept)"])
#
c.C2 = t(sapply(by(ooData.C2,list(sid = ooData.C2$sid),function(x) lm (bid ~ v + oo,data = x)),coef))
plot(c.C2[,c("v","oo")])
cumul(c.C2[,"v"])
cumul(c.C2[,"oo"])
cumul(c.C2[,"(Intercept)"])
#
#--------------------------------------------------------------------------------
#
# question: is it problematic to approximate non-linear bids with stepwise linear functions:


bC1 = function (x) {
  ifelse(x<50,2/3 * x,(100*x*x-2*x*x*x/3-250000/3)/(200*x-x*x-5000))
}

invbC1 = function (b) {
  if(b<=0) return (0)
  if(b>=50) return (100)
  uniroot(function(x) bC1(x)-b,c(0,100))$root
}
probWin = function (b) {
  x = invbC1(b)
  ifelse(x<50,x*x/5000,1-(100-x)*(100-x)/5000)
}

sGain = function (b,v,w) {
  p = probWin(b)
  (v-b) * p + w * (1-p)
}

vsGain = Vectorize(sGain)

## plot(function(b) vsGain(b,100,50),0,50)

segGain = function (bMin,bMax,vMin,w) {
##  plot (function(del) vsGain(bMin+del*(bMax-bMin),vMin+10*del,w),0,1)
  integrate (function(del) vsGain(bMin+del*(bMax-bMin),vMin+10*del,w),0,1)$value
}

vsegGain = Vectorize(segGain)
## plot(function(x) vsegGain(33.333,x,50,0),33,40)

nexpGain = function (bVec,w) {
  tGain = 0
  for (i in 1:5) tGain = tGain - segGain (bVec[i],bVec[i+1],i*10+40,w)
  tGain
}

rm(bw)
rm(ww)
bw=array(dim=c(51,6))
ww=array(dim=51)
for (i in seq(50,50,1)) {
  ww[i+1]=i
  bw[i+1,]=nlm(nexpGain,p=bC1(seq(50-i,100-i,10)),w=i)$estimate
  save(bw,ww,file="bwww.Rdta")
  print(i)
}
load("bwww.Rdta")



for (i in seq(50,0,-1)) {
  vec=cbind(seq(50-i,100-i,10),bw[i+1,])
  cat("\\psline")
  cat(apply ( vec, 1, function(x) {sprintf("(%g,%.4f)",x[1],x[2])}),sep="") ;
  cat("\n")
}


for (i in seq(50,0,-1)) {
  for (j in c(1:5)) {
    del=.2
    linCom=rbind(seq(1,0,-del),seq(0,1,del))
    Xes = c(40-i+j*10,50-i+j*10) %*% linCom
    mDiff=bw[i+1,c(j,j+1)] %*% linCom - bC1(Xes)
    vec=t(rbind(Xes,mDiff))
    cat("\\pscurve")
    cat(apply ( vec, 1, function(x) {sprintf("(%g,%.4f)",x[1],x[2])}),sep="") ;
    cat("\n")
  }
    cat("%\n")
}
#--------------------------------------------------------------------------------
help.start()
wert = sort(runif(50,min=50,max=100))
bid = (wert-50)/2+50
otherbid = runif(50,50,75)
income = ifelse(bid>otherbid,wert-bid,NA)
for (i in 1:50) {
  gain = ifelse(bid[i]>otherbid[i],sprintf("%.2f",wert[i]-bid[i]),"-")
  cat(sprintf("* %d) & %.2f & %.2f & %s \\\\  \n",i,wert[i],bid[i],gain))
}
help("for")

